function [B_h, C_h, M_h, A_h] = capital_matrix

global_vars;

ZERO = sparse(zeros(n_u_node,n_u_node));
ZERO_C = sparse(zeros(n_p_node,n_u_node));
if elem_type == 0
    N_k = 1;
elseif elem_type == 1
    N_k = 3;
    %    elem_p_node_pos = get_elem_p_node; % Get p nodes for every element.
end
for i=1:2
    C_h{i} = ZERO_C; % C{1}(:,:) denotes the value when j=1, and C{2}(:,:) when j=2
end

B_h = ZERO;
M_h = ZERO;
A_h{1} = ZERO;
A_h{2} = ZERO;
for elem_no=1:n_elem;
    node_no = elem_u_node_pos(elem_no,:);
    JACOBIAN = Jacobian(elem_no);
    if elem_type == 0
        node_no_p = elem_no;
    elseif elem_type == 1
        node_no_p = elem_p_node_pos(elem_no,:);
    end
    for k=1:n_u_node_per_elem
        K = u_node_pos_to_val(node_no(k));
        u_shape_k = shape_quad(:,k); % u_comp_shape(k,quad_2d_point);
        u_shape_grad_k = shape_quad_grad(:, 2*k-1:2*k)*inv_relative_POS{elem_no}; % u_shape_grad(elem_no,k,quad_2d_point);
        for l=1:n_u_node_per_elem
            L = u_node_pos_to_val(node_no(l));
            u_shape_l = shape_quad(:,l); % u_comp_shape(l,quad_2d_point);
            u_shape_grad_l = shape_quad_grad(:, 2*l-1:2*l)*inv_relative_POS{elem_no}; % u_shape_grad(elem_no,l,quad_2d_point);
            B_h(L,K) = B_h(L,K) + sum(sum(JACOBIAN*[quad_2d_weight,quad_2d_weight].*(u_shape_grad_k.*u_shape_grad_l),1));
            M_h(L,K) = M_h(L,K) + sum(JACOBIAN*quad_2d_weight.*(u_shape_k.*u_shape_l),1);
            A_h{1}(L,K) = A_h{1}(L,K) + JACOBIAN*quad_2d_weight'*(u_shape_grad_k(:,1).*u_shape_l);
            A_h{2}(L,K) = A_h{2}(L,K) + JACOBIAN*quad_2d_weight'*(u_shape_grad_k(:,2).*u_shape_l);
        end
        for m=1:N_k
            p_shape_m = p_comp_shape(m,quad_2d_point);
            SUM = sum(JACOBIAN*[quad_2d_weight,quad_2d_weight].*[p_shape_m,p_shape_m].*u_shape_grad_k,1);
            if elem_type == 0
                C_h{1}(elem_no,K) = SUM(1,1);
                C_h{2}(elem_no,K) = SUM(1,2);
            elseif elem_type ==1
                M = p_node_pos_to_val(node_no_p(m));
                C_h{1}(M,K) = C_h{1}(M,K) + SUM(1,1);
                C_h{2}(M,K) = C_h{2}(M,K) + SUM(1,2);
            end
        end
    end
end